<?php
/*
Plugin Name: Distance calculator (Avtodispetcher.Ru)
Plugin URI: https://www.avtodispetcher.ru/distance/export/wordpress/
Description: Display a distance calculator.
Version: 1.1.0
Author: Ilya Guk
Author URI: https://www.avtodispetcher.ru/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St - 5th Floor, Boston, MA  02110-1301, USA.

*/

require_once('avtodispetcher_admin.php');
require_once('avtodispetcher_widget.php');

register_activation_hook(__FILE__, 'autodisp_install');
register_deactivation_hook( __FILE__, 'autodisp_remove' );
add_action('plugins_loaded', 'language_init');
add_action('wp_print_footer_scripts', 'form_js_settings' );

function language_init(){
    load_plugin_textdomain('distance-calculator', false, basename( dirname( __FILE__ ) ) . '/languages/' );
}

function add_new_menu_item($autodisp_page_id) {
    global $wpdb;

    // let's get the first available menu
    $menu_id = $wpdb->get_var("SELECT t1.term_id FROM $wpdb->terms t1 JOIN $wpdb->term_taxonomy t2 ON ( t1.term_id = t2.term_id ) WHERE t2.taxonomy = 'nav_menu' LIMIT 0,1");

    if ($menu_id) {
        wp_update_nav_menu_item( $menu_id, 0, array(
                'menu-item-object-id' 	=> $autodisp_page_id,
                'menu-item-object'		=> 'page',
                'menu-item-type'     	=> 'post_type',
                'menu-item-status'		=> 'publish'
            )
        );
    }
}

function activate_widget() {
    $sidebars = $final_sidebars = get_option('sidebars_widgets');
    unset($sidebars['wp_inactive_widgets']);
    unset($sidebars['array_version']);

    $widget_exists = false;
    $widget_id = DistanceAvtodispetcherRu_Widget::WIDGET_ID;

    //let's iterate trough each sidebar to find if there was our widget before
    foreach ($sidebars as $sidebar) {
        $matched = preg_grep("/^" . $widget_id . ".*/", $sidebar);
        if (!empty($matched)) {
            $widget_exists = true;
            break;
        }
    }

    // if we have sidebars and the widget didn't exist
    if (!empty($sidebars) and !$widget_exists) {
        reset($sidebars);
        $first_sidebar = key($sidebars);
        $final_sidebars[$first_sidebar][] = $widget_id . '-1';
        update_option('sidebars_widgets', $final_sidebars);

        $widget = get_option($widget_id);
        $widget[1] = array();
        update_option('widget_' . $widget_id, $widget);
    }
}

function autodisp_install() {
    global $wpdb;

    $autodisp_page_title = __( 'Расчет расстояний', 'distance-calculator' );
    $autodisp_page_name = 'distance-calculator';

    //look in the db if the previous post exists and save it's id to some temp variable
    $temp_page_id = get_option( 'autodisp_page_id' );

    delete_option("autodisp_page_id");
    add_option("autodisp_page_id", '0', '', 'yes');

    $the_page = null;

    // let's assume page has been renamed, let's try to get it by id
    if (  $temp_page_id ) {
        $temp_page_id = (int) $temp_page_id;
        $the_page = get_page ( $temp_page_id );
    }

    if ( ! $the_page ) {
        // Create post object
        $_p = array();
        $_p['post_title'] = $autodisp_page_title;
        $_p['post_name'] = $autodisp_page_name;
        $_p['post_content'] = "<a href='https://www.avtodispetcher.ru/distance/' id='avtd-embed-link'>https://www.avtodispetcher.ru/distance/</a><script>var _avtdq = [];</script><script src='//www.avtodispetcher.ru/distance/export/frame.js' async='async'></script><h3>Рекомендация</h3><p>Раскройте блок &laquo;расширенные настройки&raquo; для доступа к дополнительным опциям расчета маршрута. </p> <p>Зачастую необходимо проложить путь в объезд определенных стран, и для этого список государств следует перечислить через запятую в соответствующем поле. По аналогии можно убирать из расчета некоторые населенные пункты и даже сегменты дорог. Для этого в таблице разработанного маршрута поставьте галочки напротив нужных отрезков пути и нажмите кнопку &laquo;исключить отмеченное&raquo;. </p> <p>Для различных типов дорог по умолчанию указана максимальная скорость в соответствии с правилами дорожного движения. Эта скорость используется в оценке времени пути. Вы можете ввести индивидуальный скоростной режим в соответствии с вашим стилем вождения и видом транспортного средства. </p>";
        $_p['post_status'] = 'publish';
        $_p['post_type'] = 'page';
        $_p['comment_status'] = 'closed';
        $_p['ping_status'] = 'closed';
        $_p['post_category'] = array(1); // the default 'Uncatrgorised'

        // Insert the post into the database
        $the_page_id = wp_insert_post( $_p );

        add_new_menu_item( $the_page_id );

        update_option('autodisp_form_width', '');
        update_option('autodisp_form_default_from', '');
        update_option('autodisp_form_default_to', '');
        update_option('autodisp_form_currency', '');
        update_option('autodisp_form_default_fuel_price', '');
        update_option('autodisp_form_default_fuel_charge', '');
        update_option('autodisp_form_map_enabled', 1);
        update_option('autodisp_form_fuel_calc_enabled', 1);
        update_option('autodisp_form_print_link_enabled', 1);
        update_option('autodisp_form_extra_enabled', 1);
        update_option('autodisp_form_details_enabled', 1);
    } else {
        // the plugin may have been previously active and the page may just be trashed...
        $the_page_id = $the_page->ID;

        //make sure the page is not trashed...
        $the_page->post_status = 'publish';
        $the_page_id = wp_update_post( $the_page );

    }

    delete_option( 'autodisp_page_id' );
    add_option( 'autodisp_page_id', $the_page_id );
    activate_widget();
}


function autodisp_remove() {
    global $wpdb;
    //  the id of our page...
    $the_page_id = get_option( 'autodisp_page_id' );

    if( $the_page_id ) {
        // force to _delete_ post ( not trash )
        wp_delete_post( $the_page_id , true );
    }

    delete_option("autodisp_page_id");
}

function form_js_settings() {
    $autodisp_lang = "ru";
    if (strpos( get_bloginfo('language'), 'uk' ) !== false) {
        $autodisp_lang = "ua";
    }
    if (strpos( get_bloginfo('language'), 'en' ) !== false) {
        $autodisp_lang = "en";
    }
    $autodisp_form_width = get_option('autodisp_form_width');
    $autodisp_form_default_from = get_option('autodisp_form_default_from');
    $autodisp_form_default_to = get_option('autodisp_form_default_to');
    $autodisp_form_currency = get_option('autodisp_form_currency');
    $autodisp_form_default_fuel_price = get_option('autodisp_form_default_fuel_price');
    $autodisp_form_default_fuel_charge = get_option('autodisp_form_default_fuel_charge');

    $autodisp_form_map_enabled = intval(get_option('autodisp_form_map_enabled'));
    $autodisp_form_fuel_calc_enabled = intval(get_option('autodisp_form_fuel_calc_enabled'));
    $autodisp_form_print_link_enabled = intval(get_option('autodisp_form_print_link_enabled'));
    $autodisp_form_extra_enabled = intval(get_option('autodisp_form_extra_enabled'));
    $autodisp_form_details_enabled = intval(get_option('autodisp_form_details_enabled'));

    echo '<script>';
    echo '_avtdq.push("language", "' . $autodisp_lang . '"); ';
    echo (strlen($autodisp_form_width) > 0) ? '_avtdq.push("width", "' . $autodisp_form_width . '"); ' : '';
    echo (strlen($autodisp_form_default_from) > 0) ? '_avtdq.push("default_from", "' . $autodisp_form_default_from . '"); ' : '';
    echo (strlen($autodisp_form_default_to) > 0) ? '_avtdq.push("default_to", "' . $autodisp_form_default_to . '"); ' : '';
    echo (strlen($autodisp_form_currency) > 0) ? '_avtdq.push("currency", "' . $autodisp_form_currency . '"); ' : '';
    echo ($autodisp_form_default_fuel_price > 0) ? '_avtdq.push("default_fuel_price", ' . $autodisp_form_default_fuel_price . '); ' : '';
    echo ($autodisp_form_default_fuel_charge > 0) ? '_avtdq.push("default_fuel_charge", ' . $autodisp_form_default_fuel_charge . '); ' : '';
    echo (0 == $autodisp_form_map_enabled) ? '_avtdq.push("enable_map", false); ' : '';
    echo (0 == $autodisp_form_fuel_calc_enabled) ? '_avtdq.push("enable_fuel_calc", false); ' : '';
    echo (0 == $autodisp_form_print_link_enabled) ? '_avtdq.push("enable_print_link", false); ' : '';
    echo (0 == $autodisp_form_extra_enabled) ? '_avtdq.push("enable_extra_settings", false); ' : '';
    echo (0 == $autodisp_form_details_enabled) ? '_avtdq.push("enable_route_details", false); ' : '';
    echo '</script>';
}