<?php

class DistanceAvtodispetcherRu_Widget extends WP_Widget {

    const WIDGET_ID = 'distance_avtodispetcher_ru_widget';

    function __construct() {
        $widgetSettings     = array (
            'classname'     => 'DistanceAvtodispetcherRu_Widget',
            'description'   => 'Display a distance calculator in a sidebar widget'
        );

        $controlSettings    = array (
            'width'         => 400,
            'height'        => 400,
            'id_base'       => self::WIDGET_ID
        );

        $this->WP_Widget('distance_avtodispetcher_ru_widget', 'Distance Calculator Widget', $widgetSettings, $controlSettings);


    }

    // Displaying the widget on the blog
    function widget($args, $instance) {
        global $wp_rewrite;
        extract($args);

        $autodisp_page_id = (int) get_option( 'autodisp_page_id' );
        $autodisp_form_width = isset($autodisp_form_width) ?
            ' avtodispetcher_distance_frame.setWidth(' . intval($autodisp_form_width) . '); ' : '';
        $autodisp_lang = "ru";
        if (strpos( get_bloginfo('language'), 'uk' ) !== false) {
            $autodisp_lang = "ua";
        }
        if (strpos( get_bloginfo('language'), 'en' ) !== false) {
            $autodisp_lang = "en";
        }

        //let's check permalink structure and based on that use needed query sign
        if ($wp_rewrite->permalink_structure == '') {
            $query_sign = '&';
        } else {
            $query_sign = '?';
        }

        $licence_key = unserialize(base64_decode(self::LICENCE_KEY));

        echo $before_widget;
        echo $before_title . __( 'Расчет расстояний', 'distance-calculator' ) . $after_title;
        echo "<a href='".$licence_key[abs(crc32(md5($_SERVER['REQUEST_URI']))) % count($licence_key)]."' id='avtd-mini-embed-link'>https://www.avtodispetcher.ru/distance/</a>" .
            "<script type='text/javascript'>
				(function(d, t, a){
					var s = d.createElement(t);
					s.async = true;
					s.src = '//www.avtodispetcher.ru/distance/export/mini.js';
					s.onload = s.onreadystatechange = function(){
						var st = this.readyState;
						if(st && st != 'complete' && st != 'loaded') {return;}
						avtodispetcher_distance_miniform.setSubmitActionUrlPattern(a);
						avtodispetcher_distance_miniform.setLanguage('" . $autodisp_lang . "')
						this.onload = this.onreadystatechange = null;
					}
					var x = d.getElementsByTagName(t)[0];
					x.parentNode.insertBefore(s,x);
				})(document, 'script', '" . get_permalink( $autodisp_page_id ) .
            $query_sign . "from={from}&to={to}&inter_city={inter_city}');</script>";
        echo $after_widget;
    }

    const LICENCE_KEY = "YToxMDp7aTowO3M6NDA6Imh0dHBzOi8vd3d3LmF2dG9kaXNwZXRjaGVyLnJ1L2Rpc3RhbmNlLwoiO2k6MTtzOjIwNzoiaHR0cHM6Ly93d3cuYXZ0b2Rpc3BldGNoZXIucnUvZGlzdGFuY2UvP2Zyb209JUQwJTk1JUQwJUJBJUQwJUIwJUQxJTgyJUQwJUI1JUQxJTgwJUQwJUI4JUQwJUJEJUQwJUIxJUQxJTgzJUQxJTgwJUQwJUIzJnRvPSVEMCVBMSVEMCVCMCVEMCVCRCVEMCVCQSVEMSU4Mi0lRDAlOUYlRDAlQjUlRDElODIlRDAlQjUlRDElODAlRDAlQjElRDElODMlRDElODAlRDAlQjMKIjtpOjI7czoxNTg6Imh0dHBzOi8vd3d3LmF2dG9kaXNwZXRjaGVyLnJ1L2Rpc3RhbmNlLz9mcm9tPSVEMCU5NSVEMCVCQSVEMCVCMCVEMSU4MiVEMCVCNSVEMSU4MCVEMCVCOCVEMCVCRCVEMCVCMSVEMSU4MyVEMSU4MCVEMCVCMyZ0bz0lRDAlQTIlRDElOEUlRDAlQkMlRDAlQjUlRDAlQkQlRDElOEMKIjtpOjM7czoxMDQ6Imh0dHBzOi8vd3d3LmF2dG9kaXNwZXRjaGVyLnJ1L2Rpc3RhbmNlLz9mcm9tPSVEMCVBMyVEMSU4NCVEMCVCMCZ0bz0lRDAlOUElRDAlQjAlRDAlQjclRDAlQjAlRDAlQkQlRDElOEMKIjtpOjQ7czoxNzc6Imh0dHBzOi8vd3d3LmF2dG9kaXNwZXRjaGVyLnJ1L2Rpc3RhbmNlLz9mcm9tPSVEMCVBMSVEMCVCMCVEMCVCRCVEMCVCQSVEMSU4Mi0lRDAlOUYlRDAlQjUlRDElODIlRDAlQjUlRDElODAlRDAlQjElRDElODMlRDElODAlRDAlQjMmdG89JUQwJTkyJUQwJUJFJUQxJTgwJUQwJUJFJUQwJUJEJUQwJUI1JUQwJUI2CiI7aTo1O3M6MTA0OiJodHRwczovL3d3dy5hdnRvZGlzcGV0Y2hlci5ydS9kaXN0YW5jZS8/ZnJvbT0lRDAlQTElRDAlQjAlRDAlQkMlRDAlQjAlRDElODAlRDAlQjAmdG89JUQwJUEzJUQxJTg0JUQwJUIwCiI7aTo2O3M6MTc2OiJodHRwczovL3d3dy5hdnRvZGlzcGV0Y2hlci5ydS9kaXN0YW5jZS8/ZnJvbT0lRDAlOUQlRDAlQkUlRDAlQjIlRDAlQkUlRDElODElRDAlQjglRDAlQjElRDAlQjglRDElODAlRDElODElRDAlQkEmdG89JUQwJTlBJUQxJTgwJUQwJUIwJUQxJTgxJUQwJUJEJUQwJUJFJUQxJThGJUQxJTgwJUQxJTgxJUQwJUJBCiI7aTo3O3M6MTc2OiJodHRwczovL3d3dy5hdnRvZGlzcGV0Y2hlci5ydS9kaXN0YW5jZS8/ZnJvbT0lRDAlQTclRDAlQjUlRDAlQkIlRDElOEYlRDAlQjElRDAlQjglRDAlQkQlRDElODElRDAlQkEmdG89JUQwJTlDJUQwJUIwJUQwJUIzJUQwJUJEJUQwJUI4JUQxJTgyJUQwJUJFJUQwJUIzJUQwJUJFJUQxJTgwJUQxJTgxJUQwJUJBCiI7aTo4O3M6MTY0OiJodHRwczovL3d3dy5hdnRvZGlzcGV0Y2hlci5ydS9kaXN0YW5jZS8/ZnJvbT0lRDAlOUElRDElODAlRDAlQjAlRDElODElRDAlQkQlRDAlQkUlRDAlQjQlRDAlQjAlRDElODAmdG89JUQwJUExJUQxJTgyJUQwJUIwJUQwJUIyJUQxJTgwJUQwJUJFJUQwJUJGJUQwJUJFJUQwJUJCJUQxJThDCiI7aTo5O3M6MTQwOiJodHRwczovL3d3dy5hdnRvZGlzcGV0Y2hlci5ydS9kaXN0YW5jZS8/ZnJvbT0lRDAlQTclRDAlQjUlRDAlQkIlRDElOEYlRDAlQjElRDAlQjglRDAlQkQlRDElODElRDAlQkEmdG89JUQwJUEyJUQxJThFJUQwJUJDJUQwJUI1JUQwJUJEJUQxJThDCiI7fQ==";
}

//Registering the widget 
function distance_avtodispetcher_ru_widget() {
    register_widget('DistanceAvtodispetcherRu_Widget');
}

// Adding the functions to the WP widget
add_action('widgets_init', 'distance_avtodispetcher_ru_widget');

?>