<?php

add_action('admin_menu', 'distance_calculator_add_page');

function distance_calculator_add_page() {
    add_options_page(
		__( 'Настройки калькулятора расстояний', 'distance-calculator' ),
		__('Настройки калькулятора расстояний','distance-calculator'),
		'manage_options',
		'distance-calculator-settings',
		'distance_calculator_settings_page' );
}

function distance_calculator_settings_page() {
    echo "<h2>" . __( 'Настройки калькулятора расстояний', 'distance-calculator' ) . "</h2>";
	distance_calculator_settings_form();
}

function distance_calculator_settings_form() {
	if (isset($_POST['autodisp_form_width'])) {
        update_option('autodisp_form_width', $_POST['autodisp_form_width']);
        update_option('autodisp_form_default_from', $_POST['autodisp_form_default_from']);
        update_option('autodisp_form_default_to', $_POST['autodisp_form_default_to']);
        update_option('autodisp_form_currency', $_POST['autodisp_form_currency']);
        update_option('autodisp_form_default_fuel_price', $_POST['autodisp_form_default_fuel_price']);
        update_option('autodisp_form_default_fuel_charge', $_POST['autodisp_form_default_fuel_charge']);
        update_option('autodisp_form_map_enabled', intval('on' == $_POST['autodisp_form_map_enabled']));
        update_option('autodisp_form_fuel_calc_enabled', intval('on' == $_POST['autodisp_form_fuel_calc_enabled']));
        update_option('autodisp_form_print_link_enabled', intval('on' == $_POST['autodisp_form_print_link_enabled']));
        update_option('autodisp_form_extra_enabled', intval('on' == $_POST['autodisp_form_extra_enabled']));
        update_option('autodisp_form_details_enabled', intval('on' == $_POST['autodisp_form_details_enabled']));
        echo '<div class="updated">' . __( 'Сохранено', 'distance-calculator' ) . '</div>';
	}
?>
	<form action="" method="post">
		<p>
			<label for="autodisp_form_width">
				<?php echo __('Ширина модуля', 'distance-calculator') ?>
			</label>
			<br />
			<input type="text" name="autodisp_form_width" id="autodisp_form_width" value="<?php echo get_option('autodisp_form_width') ?>">
		</p>
        <p>
            <label for="autodisp_form_default_from">
                <?php echo __('Город ОТКУДА по-умолчанию', 'distance-calculator') ?>
            </label>
            <br />
            <input type="text" name="autodisp_form_default_from" id="autodisp_form_default_from" value="<?php echo get_option('autodisp_form_default_from') ?>">
        </p>
        <p>
            <label for="autodisp_form_default_to">
                <?php echo __('Город КУДА по-умолчанию', 'distance-calculator') ?>
            </label>
            <br />
            <input type="text" name="autodisp_form_default_to" id="autodisp_form_default_to" value="<?php echo get_option('autodisp_form_default_to') ?>">
        </p>
        <p>
            <label for="autodisp_form_currency">
                <?php echo __('Валюта', 'distance-calculator') ?>
            </label>
            <br />
            <input type="text" name="autodisp_form_currency" id="autodisp_form_currency" value="<?php echo get_option('autodisp_form_currency') ?>">
        </p>
        <p>
            <label for="autodisp_form_default_fuel_price">
                <?php echo __('Цена топлива по-умолчанию', 'distance-calculator') ?>
            </label>
            <br />
            <input type="text" name="autodisp_form_default_fuel_price" id="autodisp_form_default_fuel_price" value="<?php echo get_option('autodisp_form_default_fuel_price') ?>">
        </p>
        <p>
            <label for="autodisp_form_default_fuel_charge">
                <?php echo __('Расход топлива по-умолчанию', 'distance-calculator') ?>
            </label>
            <br />
            <input type="text" name="autodisp_form_default_fuel_charge" id="autodisp_form_default_fuel_charge" value="<?php echo get_option('autodisp_form_default_fuel_charge') ?>">
        </p>
        <p>
            <label>
                <input type="checkbox" name="autodisp_form_map_enabled" <?php if (intval(get_option('autodisp_form_map_enabled')) > 0) : ?>checked="checked"<?php endif ?>>
                <?php echo __('Включена карта маршрута', 'distance-calculator') ?>
            </label>
        </p>
        <p>
            <label>
                <input type="checkbox" name="autodisp_form_fuel_calc_enabled" <?php if (intval(get_option('autodisp_form_fuel_calc_enabled')) > 0) : ?>checked="checked"<?php endif ?>>
                <?php echo __('Включен калькулятор топлива', 'distance-calculator') ?>
            </label>
        </p>
        <p>
            <label>
                <input type="checkbox" name="autodisp_form_print_link_enabled" <?php if (intval(get_option('autodisp_form_print_link_enabled')) > 0) : ?>checked="checked"<?php endif ?>>
                <?php echo __('Включена версия для печати', 'distance-calculator') ?>
            </label>
        </p>
        <p>
            <label>
                <input type="checkbox" name="autodisp_form_extra_enabled" <?php if (intval(get_option('autodisp_form_extra_enabled')) > 0) : ?>checked="checked"<?php endif ?>>
                <?php echo __('Включены дополнительные настройки', 'distance-calculator') ?>
            </label>
        </p>
        <p>
            <label>
                <input type="checkbox" name="autodisp_form_details_enabled" <?php if (intval(get_option('autodisp_form_details_enabled')) > 0) : ?>checked="checked"<?php endif ?>>
                <?php echo __('Включена таблица детализации маршрута', 'distance-calculator') ?>
            </label>
        </p>
        <p>
            <input type="submit" name="submit" value="<?php _e("Submit") ?>" />
        </p>
	</form>
<?php
}
?>